/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ButtonHandler;
import com.ldtteam.blockout.controls.ButtonImage;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.views.Window;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.tileentities.TileEntityRack;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.network.messages.server.colony.HireSpiesMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Items;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;

public class WindowsBarracksSpies
extends Window
implements ButtonHandler {
    private static final String SPIES_GUI_XML = ":gui/windowbarracksspies.xml";
    private static final String BUTTON_CANCEL = "cancel";
    private static final String BUTTON_HIRE = "hireSpies";
    private static final String SPIES_BUTTON_ICON = "hireSpiesIcon";
    private static final String GOLD_COST_LABEL = "amount";
    private static final String TEXT_ID = "text";
    private static final int GOLD_COST = 5;
    private final IBuildingView buildingView;

    public WindowsBarracksSpies(IBuildingView buildingView, BlockPos buildingPos) {
        super("minecolonies:gui/windowbarracksspies.xml");
        this.buildingView = buildingView;
        ((ItemIcon)this.findPaneOfTypeByID(SPIES_BUTTON_ICON, ItemIcon.class)).setItem(Items.field_151043_k.func_190903_i());
        ((Text)this.findPaneOfTypeByID(GOLD_COST_LABEL, Text.class)).setText("x5");
        IItemHandlerModifiable rackInv = ((TileEntityRack)buildingView.getColony().getWorld().func_175625_s(buildingPos)).getInventory();
        InvWrapper playerInv = new InvWrapper((IInventory)Minecraft.func_71410_x().field_71439_g.field_71071_by);
        int goldCount = InventoryUtils.getItemCountInItemHandler((IItemHandler)playerInv, Items.field_151043_k);
        if (!buildingView.getColony().isRaiding() || (goldCount += InventoryUtils.getItemCountInItemHandler((IItemHandler)rackInv, Items.field_151043_k)) < 5 || buildingView.getColony().areSpiesEnabled()) {
            ((ButtonImage)this.findPaneOfTypeByID(BUTTON_HIRE, ButtonImage.class)).disable();
        }
        ((Text)this.findPaneOfTypeByID(TEXT_ID, Text.class)).setText(LanguageHandler.format((String)"com.minecolonies.coremod.gui.barracks.spies.desc", (Object[])new Object[0]));
    }

    public void onButtonClicked(Button button) {
        switch (button.getID()) {
            case "cancel": {
                this.close();
                break;
            }
            case "hireSpies": {
                ((ButtonImage)this.findPaneOfTypeByID(BUTTON_HIRE, ButtonImage.class)).disable();
                Network.getNetwork().sendToServer(new HireSpiesMessage(this.buildingView.getColony()));
                this.close();
            }
        }
    }
}

